package gov.va.med.domain.model;

import org.apache.commons.lang3.builder.ToStringBuilder;


/** 
 *        @hibernate.class
 *         table="PHR_FUNCTIONS"
 *     
*/
public class PhrFunction extends DomainObject {

    /** persistent field */
    private Long priority;

    /** nullable persistent field */
    private gov.va.med.domain.model.Function function;

    /** full constructor */
    public PhrFunction(Long id, Long priority, gov.va.med.domain.model.Function function) {
        this.setId(id);
        this.priority = priority;
        this.function = function;
    }

    /** default constructor */
    public PhrFunction() {
    }

    /** minimal constructor */
    public PhrFunction(Long id, Long priority) {
        this.setId(id);
        this.priority = priority;
    }

    /** 
     *            @hibernate.property
     *             column="PRIORITY"
     *             update="false"
     *             insert="false"
     *             length="22"
     *             not-null="true"
     *         
     */
    public Long getPriority() {
        return this.priority;
    }

    public void setPriority(Long priority) {
        this.priority = priority;
    }

    /** 
     *            @hibernate.one-to-one
     *             class="gov.va.med.domain.model.Function"
     *             outer-join="auto"
     *             constrained="true"
     *         
     */
    public gov.va.med.domain.model.Function getFunction() {
        return this.function;
    }

    public void setFunction(gov.va.med.domain.model.Function function) {
        this.function = function;
    }

    public String toString() {
        return new ToStringBuilder(this)
            .append("id", getId())
            .append("priority", getPriority())
            .toString();
    }

}
